<?php
/* --------------------------------------------------------------
   ParcelServiceApiServiceProvider.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\ParcelService;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceService;
use Gambio\Api\ParcelService\Actions\CreateParcelServicesAction;
use Gambio\Api\ParcelService\Actions\DeleteParcelServicesAction;
use Gambio\Api\ParcelService\Actions\FetchAllParcelServicesAction;
use Gambio\Api\ParcelService\Actions\FetchSpecificParcelServiceAction;
use Gambio\Api\ParcelService\Actions\UpdateParcelServicesAction;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;

/**
 * Class ParcelServiceApiServiceProvider
 *
 * @package Gambio\Api\ParcelService
 * @codeCoverageIgnore
 */
class ParcelServiceApiServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            CreateParcelServicesAction::class,
            DeleteParcelServicesAction::class,
            FetchSpecificParcelServiceAction::class,
            FetchAllParcelServicesAction::class,
            UpdateParcelServicesAction::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->add(ParcelServiceApiRequestParser::class);
        
        $this->application->add(ParcelServiceApiRequestValidator::class);
        
        $this->application->share(CreateParcelServicesAction::class)
            ->addArgument(ParcelServiceApiRequestParser::class)
            ->addArgument(ParcelServiceApiRequestValidator::class)
            ->addArgument(ParcelServiceService::class);
        
        $this->application->share(DeleteParcelServicesAction::class)->addArgument(ParcelServiceService::class);
        
        $this->application->share(FetchSpecificParcelServiceAction::class)->addArgument(ParcelServiceService::class);
        
        $this->application->share(FetchAllParcelServicesAction::class)
            ->addArgument(ParcelServiceApiRequestParser::class)
            ->addArgument(ParcelServiceService::class);
        
        $this->application->share(UpdateParcelServicesAction::class)
            ->addArgument(ParcelServiceApiRequestValidator::class)
            ->addArgument(ParcelServiceService::class);
    }
}